\version "2.24.0"
%\language "deutsch"

\paper {
  markup-system-spacing = #'((basic-distance . 23))
  system-system-spacing = #'((basic-distance . 16))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  %ragged-last-bottom=##f
  %system-count = #3
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "In dulci jubilo"
  subtitle = " "
  %subsubtitle = "Op. 19"
  %poet = ""
  composer = \markup \center-column { "Michael Praetorius"
  \small "(1571 - 1621)" }
  %arranger = "io"
  %meter = "nu prea încet"
  tagline=""
}

global = {
  \key g \major
  \autoBeamOff
  %\cadenzaOn
  \time 3/4
  \partial 4
  \set Staff.midiInstrument = "clarinet"
}

womenWordsOne = \lyricmode {
  \set stanza = "1."
  In dul -- ci ju -- bi -- lo __
  nun sin -- get und seid froh! __
  Un -- sers Her -- zens Won -- ne
  leit in prae -- se -- pi -- o __
  und leuch -- tet als die Son -- ne
  ma -- tris in gre -- mi -- o. __
  Al -- pha es et O, __ Al --  pha es __ et O.
}

womenWordsTwo = \lyricmode {
  \set stanza = "2."
  O Je -- su par -- vu -- lé, __
  nach dir ist mir so weh; __
  tröst mir mein Ge -- mü -- te,
  o pu -- er op -- ti -- me, __
  durch al -- le dei -- ne Gü -- te,
  o prin -- ceps glo -- ri -- ae. __
  Tra -- he me post te, __ tra -- he me __ post te.
}

womenWordsThree = \lyricmode {
  \set stanza = "3."
   O pa -- tris ca -- ri -- tas, __
   o na -- ti le -- ni -- tas! __
   Wir wärn all ver -- lo -- ren 
   per no -- stra cri -- mi -- na, __
   so hat er uns er -- wor -- ben
   coe -- lo -- rum gau -- di -- a. __
   Ei -- a, wärn wir da, __ ei -- a, wärn wir da.
}

womenWordsFour = \lyricmode {
  \set stanza = "4."
  U -- bi sunt gau -- di -- a? __
  "( )" Nir -- gend mehr denn da, __
  da die En -- gel sin -- gen 
  "( )" no -- va can -- ti -- ca __
  "( )"und die Schel -- len klin -- gen
  in re -- gis cu -- ri -- a. __
  Ei -- a, wärn wir da, __ ei -- a wärn wir da!
}

womenWordsFive = \lyricmode {
  \set stanza = "5."
  
}

sopMusic = \relative c'' {
  g4
  g2 g4 b2 c4 d2( e4 d2) d4 g,2 g4 b2 c4 d2 (e4 d2.)
  d2 e4 d2 c4 b4.( a8 b4) g2 g4 a2 a4 b2 a4 g2( a4 b2)
  d4 d2 e4 d2 c4 b4.( a8 b4) g2 g4 a2 a4 b2 a4 g2( a4 b2.)
  e,2 e4 fis2 fis4 g2.( d'2.) b2 b4 a4( g4) a4 g2.
  \bar "|."
}

bassMusic =  \relative c' {
  g4 e2 c4 g2 c4 b4( d4 a4) d2 g4 e8([ fis] g4) c,4 
  g'8([ fis]) e([ d] c4) b8([ c] d4 a4 d2.) 
  g2 c,4 d2 a4 e'4.( fis8 g4) c,2 e4 a,2 d4
  g2 d4 e2( a4 g2) d4 g2 e4 g2 a4 b4.( c8 b4)
  e,2 e4 a,2 d4 g2 d4 e4.( d8 c4 b2.)
  c2 c4 a2 a4 g4( g'4 e4 d2.) g2 g4 d4( e4) d4 <g g,>2.
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff = "staff" <<
     \new Voice { \global \sopMusic }
     %\new Lyrics \with { alignAboveContext = "staff" } { \sopWords }
     \addlyrics { \womenWordsOne }
     \addlyrics { \womenWordsTwo }
     \addlyrics { \womenWordsThree }
     \addlyrics { \womenWordsFour }
     \addlyrics { \womenWordsFive }
     %\new Voice { \voiceTwo \global \altMusic }   
     %\addlyrics { \womenWordsFour }
    >>
    
    \new Staff <<
      \clef bass
      %\new Voice { \global \bassMusic }
      %\new Voice { \global \tenorMusic }
      %\new Lyrics \with { alignAboveContext = "staff" } { \tenorWords }
      %\new Voice { \voiceOne \global \tenorMusic }
      %\addlyrics { \tenWords }
      \new Voice { \global \bassMusic }
      %\new Voice { \global \bassMusic }
      %\addlyrics { \basWordsOne }
      %\addlyrics { \basWordsTwo }
      %\addlyrics { \basWordsThree }  
      %\addlyrics { \basWordsFour } 
    >>
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
  \tempo 4 = 80
  \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}